/*	Copyright  2010, tuty
	HL Weapon Floating is free software;
	you can redistribute it and/or modify it under the terms of the
	GNU General Public License as published by the Free Software Foundation.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Teleport Destination Angles Editor; if not, write to the
	Free Software Foundation, Inc., 59 Temple Place - Suite 330,
	Boston, MA 02111-1307, USA.
*/



/* --| Including 2 amxmodx modules:
   --| Engine and hamsandwich 	*/

#include <amxmodx>
#include <engine>
#include <hamsandwich>


/* --| Force semicolon at every endline */
#pragma semicolon 1

/* --| Let's define the plugin version */
#define PLUGIN_VERSION	"1.0.0"

/* --| Half-Life item entity names */
new const gHalfLifeItemNames[][] = { "item_battery", "item_healthkit", "item_longjump" };


/* --| Half-Life weapons entity names */
new const gHalfLifeWeaponEntitiesNames[][] = 
{
	"ammo_357", "ammo_9mmAR", "ammo_9mmbox", "ammo_9mmclip", "ammo_ARgrenades",
	"ammo_buckshot", "ammo_crossbow", "ammo_egonclip", "ammo_gaussclip", "ammo_glockclip",
	"ammo_mp5clip", "ammo_mp5grenades", "ammo_rpgclip", "weaponbox", "weapon_357", 
	"weapon_9mmAR", "weapon_9mmhandgun", "weapon_crossbow", "weapon_egon", "weapon_gauss",
	"weapon_glock", "weapon_handgrenade", "weapon_hornetgun", "weapon_mp5", "weapon_python",
	"weapon_rpg", "weapon_satchel", "weapon_shotgun", "weapon_snark", "weapon_tripmine"
};


/* --| Some global variables */
new gFloatingWeaponsEnabled;
new gFloatingWeaponsGlow;
new gFloatingWeaponsSpeed;
new gFloatingWeaponsGlowThickness;


public plugin_init()
{
	/* --| Register the plugin too see it in amx_plugins list */
	register_plugin( "HL Weapons Floating", PLUGIN_VERSION, "tuty" );

	new i;

	for( i = 0; i < sizeof( gHalfLifeWeaponEntitiesNames ); i++ )
	{
		/* --| Using this native, we check if every weapon entity has touched the ground
		   --| Then we can modify the origins, angles, etc... */

		register_touch( gHalfLifeWeaponEntitiesNames[ i ], "worldspawn", "WeaponsTouchTheGround" );
		register_touch( gHalfLifeWeaponEntitiesNames[ i ], "func_wall", "WeaponsTouchTheGround" );
	}

	for( i = 0; i < sizeof( gHalfLifeItemNames ); i++ )
	{
		/* --| Using this ham hook we know when a item is respawned
		   --| I didn't used Ham_Spawn, or register_touch because won't work! for items idk why :(
		   --| First time items are on ground, but on next respawn will float and spin :) */

		RegisterHam( Ham_Respawn, gHalfLifeItemNames[ i ], "bacon_ItemsRespawned" );
	}

	/* --| Register the following cvars */
	gFloatingWeaponsEnabled = register_cvar( "hl_fw_enabled", "1" );
	gFloatingWeaponsGlow = register_cvar( "hl_fw_glow", "1" );
	gFloatingWeaponsSpeed = register_cvar( "hl_fw_speed", "25.0" );
	gFloatingWeaponsGlowThickness = register_cvar( "hl_fw_glow_thickness", "10.0" );
}

/* --| Weapons entities are on ground */
public WeaponsTouchTheGround( iEntity, iWorldspawn )
{
	/* --| Checking if cvar is enabled
	   --| Checking if is a valid entity */

	if( get_pcvar_num( gFloatingWeaponsEnabled ) != 0 && is_valid_ent( iEntity ) )
	{
		/* --| Now weapons are floating and spinning */
		FloatAndSpinWeapons( iEntity );
	}
}

/* --| Items are respawned */
public bacon_ItemsRespawned( iEntity )
{
	/* --| Checking if cvar is enabled.
	   --| We don't need to check if is a valid entity, because ham will hook only halflife valid entities */

	if( get_pcvar_num( gFloatingWeaponsEnabled ) != 0 )
	{
		/* --| Now weapons are floating and spinning */
		FloatAndSpinWeapons( iEntity );
	}
}

/* --| Now float and spin weapons and items */
public FloatAndSpinWeapons( iEntity )
{
	/* --| Checking entity origins */
	new Float:flWeaponOrigin[ 3 ];
	entity_get_vector( iEntity, EV_VEC_origin, flWeaponOrigin );
		
	/* --| Modify the origin, to set it a little bit in air */
	flWeaponOrigin[ 2 ] += 20.0;
		
	/* --| Now set the new origin */
	entity_set_origin( iEntity, flWeaponOrigin );

	/* --| Let's set entity movetype to noclip 
	   --| We can go trough entities */

	entity_set_int( iEntity, EV_INT_movetype, MOVETYPE_NOCLIP );
		
	/* --| After entity is respawned or on the ground, let's make it spin */
	set_task( 0.2, "WeaponSpinGoGo", iEntity );
		
	/* --| Checking if glow cvar is on and set some glow on entities */
	if( get_pcvar_num( gFloatingWeaponsGlow ) == 1 )
	{
		/* --| Create a float color variable and set on it some random colors */
		new Float:iRenderColor[ 3 ];
			
		iRenderColor[ 0 ] = random_float( 0.0, 255.0 );
		iRenderColor[ 1 ] = random_float( 0.0, 255.0 );
		iRenderColor[ 2 ] = random_float( 0.0, 255.0 );

		/* --| Here we set the glow on entity */
		entity_set_int( iEntity, EV_INT_renderfx, kRenderFxGlowShell );
		entity_set_vector( iEntity, EV_VEC_rendercolor, iRenderColor );
	
		/* --| Setting thickness amount 
		   --| Some people like big amount of thickness */

		entity_set_float( iEntity, EV_FL_renderamt, get_pcvar_float( gFloatingWeaponsGlowThickness ) );
	}
}

/* --| Here we make entities to spin */
public WeaponSpinGoGo( iEntity )
{
	/* --| Checking again if is a valid entity */
	if( is_valid_ent( iEntity ) )
	{
		/* --| Creating a avelocity variable and some modifications on it */
		new Float:flAvelocity[ 3 ];
		
		flAvelocity[ 0 ] = 0.0;
		flAvelocity[ 1 ] = get_pcvar_float( gFloatingWeaponsSpeed );
		flAvelocity[ 2 ] = 0.0;
		
		/* --| Setting a new avelocity on current enitity */
		entity_set_vector( iEntity, EV_VEC_avelocity, flAvelocity );
	}
}

/* --| End of plugin */