#include <amxmodx>
#include <amxmisc>
#include <engine>

#define KZ_LEVEL ADMIN_KICK		// Adminlevel

new bool:canusehook[32]
new bool:ishooked[32]
new hookorigin[32][3]

new Sbeam

public plugin_init() {
	register_plugin("ProKreedzHook","1.0","p4ddY")
	
	register_clcmd("+hook","hook_on",KZ_LEVEL)
	register_clcmd("-hook","hook_off",KZ_LEVEL)
	
	register_clcmd("kz_hook","give_hook",KZ_LEVEL,"<name|#userid|steamid|@ALL> <on/off>")
}

public plugin_precache() {
	precache_sound("weapons/xbow_hit2.wav")
	Sbeam = precache_model("sprites/laserbeam.spr")
}

// =================================================================================================

public client_disconnect(id) {
	remove_hook(id)
}

public client_putinserver(id) {
	remove_hook(id)
}

// =================================================================================================

public give_hook(id,level,cid) {
	if(!cmd_access(id,level,cid,3))
		return PLUGIN_HANDLED
			
	new name[32]
	get_user_name(id,name,32)
		
	new szarg1[32], szarg2[8], bool:mode
	read_argv(1,szarg1,32)
	read_argv(2,szarg2,32)
	if(equal(szarg2,"on"))
		mode = true
		
	if(equal(szarg1,"@ALL")) {
		for(new i=1;i<=get_maxplayers();i++) {
			if(is_user_connected(i) && is_user_alive(i)) {
				canusehook[i-1] = mode
				if(mode) {
					client_print(i,print_chat,"[ProKreedz] Admin %s gave you ability to use hook",name)
					client_print(i,print_chat,"[ProKreedz] Just bind '+hook' on a key, you want")
				}
				else
					client_print(i,print_chat,"[ProKreedz] Admin %s removed your ability to use hook",name)
			}
		}
	}
	else {
		new pid = cmd_target(id,szarg1,2)
		if(pid > 0) {
			canusehook[pid-1] = mode
			if(mode) {
				client_print(pid,print_chat,"[ProKreedz] Admin %s gave you ability to use hook",name)
				client_print(pid,print_chat,"[ProKreedz] Just bind '+hook' on a key, you want")
			}
			else
				client_print(pid,print_chat,"[ProKreedz] Admin %s removed your ability to use hook",name)
		}
	}
	
	return PLUGIN_HANDLED
}

// =================================================================================================

public hook_on(id,level,cid) {
	if(!canusehook[id-1] && !cmd_access(id,level,cid,1))
		return PLUGIN_HANDLED
	
	get_user_origin(id,hookorigin[id-1],3)
	
	if(callfunc_begin("detect_cheat","prokreedz.amxx") == 1) {
		callfunc_push_int(id)
		callfunc_push_str("Hook")
		callfunc_end()
	}
	
	ishooked[id-1] = true
	
	emit_sound(id,CHAN_STATIC,"weapons/xbow_hit2.wav",1.0,ATTN_NORM,0,PITCH_NORM)
	set_task(0.1,"hook_task",id,"",0,"ab")
	hook_task(id)
	
	return PLUGIN_HANDLED
}

// =================================================================================================

public is_hooked(id) {
	return ishooked[id-1]
}

// =================================================================================================

public hook_off(id) {
	remove_hook(id)
	
	return PLUGIN_HANDLED
}

// =================================================================================================

public hook_task(id) {
	if(!is_user_connected(id) || !is_user_alive(id))
		remove_hook(id)
	
	remove_beam(id)
	draw_hook(id)
	
	new origin[3], Float:velocity[3]
	get_user_origin(id,origin) 
	new distance = get_distance(hookorigin[id-1],origin)
	if(distance > 25)  { 
		velocity[0] = (hookorigin[id-1][0] - origin[0]) * (2.0 * 300 / distance)
		velocity[1] = (hookorigin[id-1][1] - origin[1]) * (2.0 * 300 / distance)
		velocity[2] = (hookorigin[id-1][2] - origin[2]) * (2.0 * 300 / distance)
		
		entity_set_vector(id,EV_VEC_velocity,velocity)
	} 
	else {
		entity_set_vector(id,EV_VEC_velocity,Float:{0.0,0.0,0.0})
		remove_hook(id)
	}
}

// =================================================================================================

public draw_hook(id) {
	message_begin(MSG_BROADCAST,SVC_TEMPENTITY)
	write_byte(1)				// TE_BEAMENTPOINT
	write_short(id)				// entid
	write_coord(hookorigin[id-1][0])	// origin
	write_coord(hookorigin[id-1][1])	// origin
	write_coord(hookorigin[id-1][2])	// origin
	write_short(Sbeam)			// sprite index
	write_byte(0)				// start frame
	write_byte(0)				// framerate
	write_byte(100)				// life
	write_byte(10)				// width
	write_byte(0)				// noise
	if(get_user_team(id) == 1) {		// Terrorist
		write_byte(255)			// r
		write_byte(0)			// g
		write_byte(0)			// b
	}
	else {					// Counter-Terrorist
		write_byte(0)			// r
		write_byte(0)			// g
		write_byte(255)			// b
	}
	write_byte(150)				// brightness
	write_byte(0)				// speed
	message_end()
}

public remove_hook(id) {
	if(task_exists(id))
		remove_task(id)
	remove_beam(id)
	ishooked[id-1] = false
}

public remove_beam(id) {
	message_begin(MSG_BROADCAST,SVC_TEMPENTITY)
	write_byte(99) // TE_KILLBEAM
	write_short(id)
	message_end()
}

// You reached the end of file
// This plugin was made by p4ddY :)
// Credits to EJL-SpaceDude/JTP10181