/* AMX Mod X
*   Weaponbox Models for HLDM
*
* (c) Copyright 2010 by KORD_12.7
*
* This file is provided as is (no warranties)
*/
//--------------------------------------------------------------------------------------------------
#include <amxmodx>
#include <fakemeta>
#include <colors>
//--------------------------------------------------------------------------------------------------
#define PLUGIN "Weaponbox Models for HLDM"
#define VERSION "0.1"
#define AUTHOR "KORD_12.7"
//--------------------------------------------------------------------------------------------------
new
g_CvarEnable,
g_CvarRendEnable,
g_CvarRendColor, 
g_CvarRendMode,
g_MaxPlayers,
g_RGB[3]
//--------------------------------------------------------------------------------------------------
new const g_wpn_models[][] = 
{
	"models/w_weaponbox.mdl",
	"models/w_crowbar.mdl",
	"models/w_9mmhandgun.mdl",
	"models/w_357.mdl",
	"models/w_9mmAR.mdl",
	"models/w_weaponbox.mdl",
	"models/w_crossbow.mdl",
	"models/w_shotgun.mdl",
	"models/w_rpg.mdl",
	"models/w_gauss.mdl",
	"models/w_egon.mdl",
	"models/w_hgun.mdl",
	"models/w_grenade.mdl",
	"models/v_tripmine.mdl",
	"models/w_satchel.mdl",
	"models/w_sqknest.mdl",
	"models/w_bgrap.mdl",
	"models/w_desert_eagle.mdl",
	"models/w_pipe_wrench.mdl",
	"models/w_saw.mdl",
	"models/w_displacer.mdl",
	"models/w_weaponbox.mdl",
	"models/w_shock_rifle.mdl",
	"models/w_spore_launcher.mdl",
	"models/w_m40a1.mdl",
	"models/w_knife.mdl"
}
//--------------------------------------------------------------------------------------------------
public plugin_init() 
{
	register_plugin(PLUGIN, VERSION, AUTHOR)
	register_cvar("wpnbox_version", VERSION, FCVAR_SERVER)
	
	register_forward(FM_SetModel, "fw_SetModel")
	
	g_CvarEnable = register_cvar("wpnbox_models", "1")
	g_CvarRendEnable = register_cvar("wpnbox_render", "1")
	g_CvarRendColor = register_cvar("wpnbox_render_color", "random")
	
	g_MaxPlayers = get_maxplayers()
}
//--------------------------------------------------------------------------------------------------
public plugin_cfg()
{
	new color[32]
	get_pcvar_string(g_CvarRendColor, color, charsmax(color))
	
	if(equal(color, "random"))
		g_CvarRendMode = 0
	else
	{
		colors_init()
		get_full_color(color, g_RGB)
		g_CvarRendMode = 1
	}
}
//--------------------------------------------------------------------------------------------------
public fw_SetModel(eEnt) 
{
	if (!pev_valid(eEnt) || !get_pcvar_num(g_CvarEnable))
		return FMRES_IGNORED

	static classname[32]
	pev(eEnt, pev_classname, classname, charsmax(classname))
	
	if(!equal(classname, "weaponbox"))
		return FMRES_IGNORED

	static id
	id = pev(eEnt, pev_owner)
	
	if(!(1 <= id <= g_MaxPlayers))
		return FMRES_IGNORED

	static wpn_id
	wpn_id = get_user_weapon(id)
	
	if(!(HLW_CROWBAR <= wpn_id <= 25))	
		return FMRES_IGNORED

	engfunc(EngFunc_SetModel, eEnt, g_wpn_models[wpn_id])
	
	if(get_pcvar_num(g_CvarRendEnable))
	{
		switch(g_CvarRendMode)
		{
			case 1: fm_set_rendering(eEnt, kRenderFxGlowShell, g_RGB[0], g_RGB[1], g_RGB[2], kRenderNormal, 16)
			case 0: fm_set_rendering(eEnt, kRenderFxGlowShell, random_num(1, 255), random_num(1, 255), random_num(1, 255), kRenderNormal, 16)
		}
	}

	return FMRES_SUPERCEDE
}
//--------------------------------------------------------------------------------------------------
fm_set_rendering(eEnt, fx = kRenderFxNone, r = 0, g = 0, b = 0, mode = kRenderNormal, amount = 16)
{
	static Float: RenderColor[3] 
	
	RenderColor[0] = float(r)
	RenderColor[1] = float(g)
	RenderColor[2] = float(b)
	
	set_pev(eEnt, pev_renderfx, fx)
	set_pev(eEnt, pev_rendercolor, RenderColor)
	set_pev(eEnt, pev_rendermode, mode)
	set_pev(eEnt, pev_renderamt, float(amount))
}
