/*
Mateusz R3X Derks
Colors.inc [v1.3]
@2009
---------
It helps in work with colors.
Default support dec&hexRGB colors, but when you call colors_init() can convert names*1 too.

From different ways of showing color gets array of RGB colors 

	new iColor[3]={R, G, B}

for plugin configuration.


Functions:
---------------------------------------------------------
get_full_color(const color[], iColor[3]) 
	- main function of .inc

	get_full_color("#FFFFFF",iColor); //iColor={255,255,255}
	get_full_color("white",iColor); //iColor={255,255,255}
	get_full_color("255255255",iColor); //iColor={255,255,255}	
	get_full_color("255 255 255",iColor); //iColor={255,255,255}
	
	get_full_color("255 25 255",iColor); //iColor={255,25,255}

---------------------------------------------------------
get_color(const color[],ColorsP:type) 
	- work with hexRGB or named color
	- type is one from list:
	enum ColorsP
	{
		R=1, // Red
		G, // Green
		B // Blue
	}
---------------------------------------------------------

*1 please check configs/colors.ini

---------
*/
#if !defined _amxmisc_included
	#include <amxmisc>
#endif

#if defined _colors_included
	#endinput
#endif

#define _colors_included

//max len of color name
#define COLORS_NAME_LEN 23
//max len of color value (FFFFFF so should stay 6)
#define COLORS_VALUE_LEN 6

#define RED_FIELD 0
#define GREEN_FIELD 2
#define BLUE_FIELD 4

#if COLORS_NAME_LEN < BLUE_FIELD+1
	#define COLORS_NAME_LEN BLUE_FIELD+1
#endif


new Array:g_ColorNames;
new Array:g_ColorValues;
new bool:Initialized=false;
enum ColorsP
{
	R=1, // Red
	G, // Green
	B // Blue
}

//init function
/*
//to enable color names (aliasses) your plugin_init() should call colors_init()
[code]
public plugin_init(){
	register_plugin(PLUGIN, VERSION, AUTHOR);
	colors_init();
}
[/code]
If you don`t do it function get_color() will be work only with hex RGB colors: #RRGGBB

Function return number of found colors in colors.ini
*/
#define COLORS_FILE "colors.ini"
public colors_init(){
	if(Initialized)
		return -1;
	new ini[100];
	get_configsdir(ini,88);
	add(ini,89,"/");
	add(ini,99,COLORS_FILE);
	if(!file_exists(ini))
		return 0;
	new line[COLORS_NAME_LEN+COLORS_VALUE_LEN+5],color[COLORS_VALUE_LEN+1],len,i;
	for(i=0;read_file(ini,i,line,49,len);i++){
		parse(line,line,COLORS_NAME_LEN,color,COLORS_VALUE_LEN);
		register_color(line,color);
	}
	Initialized=true;
	register_concmd("colorslist","show_colors",ADMIN_CFG);
	return i;
}
//draw list in user console
public show_colors(id){
	new name[COLORS_NAME_LEN+1], color[COLORS_VALUE_LEN+1];
	for(new i=0;i<ArraySize(g_ColorNames);i++){
		ArrayGetString(g_ColorNames, i, name, COLORS_NAME_LEN);
		ArrayGetString(g_ColorValues, i, color, COLORS_VALUE_LEN);
		console_print(id,"[%d] %s -> #%s",i+1,name,color);
	}
}
//add color to list
//added in one of plugin work with all, but it is not good way
//to add color name you should edit configs/colors.ini file
stock register_color(const szColorName[], const szColorHexValue[]){
	if(!g_ColorNames)
		g_ColorNames=ArrayCreate(COLORS_NAME_LEN+1);
	if(!g_ColorValues)
		g_ColorValues=ArrayCreate(COLORS_VALUE_LEN+1);
	//buffering
	new szColorName2[COLORS_NAME_LEN+1],szColorHexValue2[COLORS_VALUE_LEN+1];
	copy(szColorName2,COLORS_NAME_LEN,szColorName);
	//gnireffeb
	
	strtoupper(szColorName2);
	trim(szColorName2);
	color_by_name(szColorName2,szColorHexValue2);
	if(equal(szColorHexValue2,"NONE")){
	ArrayPushString(g_ColorNames,szColorName2);
	
	copy(szColorHexValue2,COLORS_VALUE_LEN,szColorHexValue);
	strtoupper(szColorHexValue2);
	trim(szColorHexValue2);
	ArrayPushString(g_ColorValues,szColorHexValue2);
	}
}
/*
Return decimal value of color contained in hex color
------
[code]
get_color("#FF00FF",R)=255 	//red
get_color("#FF00FF",G)=0		//green
get_color("#FF00FF",B)=255	//blue
[/code]
---
when colors names enabled works too with:
this example need
	[code]
	white FFFFFF
	[/code]
line in configs/colors.ini
---
[code]
get_color("white",R)=255	//red
get_color("white",G)=255	//green
get_color("white",B)=255	//blue
[/code]
------
*/
//Buffers
new szLastName[COLORS_NAME_LEN+1];
new szLastValue[COLORS_VALUE_LEN+1];
stock get_color(const color[],ColorsP:type){
	static szColor[COLORS_NAME_LEN+1];
	copy(szColor,COLORS_NAME_LEN,color);
	strtoupper(szColor);
	trim(szColor);
	
	if(szColor[0]=='#'){
		replace(szColor,COLORS_NAME_LEN,"#","");
	}else{
		if(equali(szLastName,szColor)){
			copy(szColor,COLORS_NAME_LEN, szLastValue);
		}else{
			copy(szLastName,COLORS_NAME_LEN, szColor);
			color_by_name(szColor,szColor);
			copy(szLastValue,COLORS_NAME_LEN, szColor);
		}
	}
	if(equal(szColor,"NONE"))
		return -1;
	new n=0;
	switch(type){
		case R:{//red
			n=RED_FIELD;
		}
		case G:{//green
			n=GREEN_FIELD;
		}
		case B:{//blue
			n=BLUE_FIELD;
		}
	}
	return hex2dec(szColor[n],szColor[n+1]);
}
/*
+1.3 its main function, look on begin of code
*/
stock get_full_color(const color[], iColor[3]){
	static szBuff[COLORS_NAME_LEN+1];
	copy(szBuff, COLORS_NAME_LEN, color);
	trim(szBuff);
	
	if(contain(szBuff, " ") > 0){
		new szBuff2[10];
		strtok(szBuff, szBuff2, 9, szBuff, COLORS_NAME_LEN,' ',1);
		iColor[0]=str_to_num(szBuff2);
		if(contain(szBuff, " ") > 0){
			strtok(szBuff, szBuff2, 9, szBuff, COLORS_NAME_LEN,' ',1);
			iColor[1]=str_to_num(szBuff2);
			iColor[2]=str_to_num(szBuff);
		}else{
			iColor[1]= str_to_num(szBuff);
			iColor[2]=0;
		}	
	}
	else if(is_str_num( szBuff )){
		color_from_numeric(szBuff,iColor);
	}else{
		new iColor2[3];
		iColor[0]=get_color(szBuff,R);
		iColor[1]=get_color(szBuff,G);
		iColor[2]=get_color(szBuff,B);
		if(iColor2[0]==-1
		|| iColor2[1]==-1
		|| iColor2[2]==-1)
			return false;
	}
	for(new i=0;i<3;i++)
		iColor[i]=clamp(iColor[i],0, 255);
	return true;
}
//color value by name
stock color_by_name(const szName[COLORS_NAME_LEN+1], szValue[]){
	if(!g_ColorNames)
		g_ColorNames=ArrayCreate(COLORS_NAME_LEN+1);
	if(!g_ColorValues)
		g_ColorValues=ArrayCreate(COLORS_VALUE_LEN+1);
	new szCName[COLORS_NAME_LEN+1];
	for(new i=0;i<ArraySize(g_ColorNames);i++){
		ArrayGetString(g_ColorNames, i, szCName, COLORS_NAME_LEN);
		if(equal(szName,szCName)){
			ArrayGetString(g_ColorValues, i, szValue, COLORS_VALUE_LEN);
			return;
		}
		
	}
	copy(szValue,4,"NONE");
}
stock color_from_numeric(const szColor[COLORS_NAME_LEN+1],iOutPut[]){
	new iNum=str_to_num(szColor);
	iOutPut[2]=iNum%1000;
	iNum/=1000;
	iOutPut[1]=iNum%1000;
	iNum/=1000;
	iOutPut[0]=iNum;
}
//decimal value for chars: 1,2,3,4,5,6,7,8,9,A,B,C,D,E,F
stock get_value(ch){
	ch-=48;
	if((ch>9 && ch<17) || ch<0)
		return 0;
	if(ch>10)
		ch-=7;
	if(ch>15)
		return 0;
	return ch;
}
//actual conversion
stock hex2dec(a,b){
	new j=get_value(a),k=get_value(b);
	if(j==-1 || k==-1)
		return 0;
	return j*16+k;
}
