#include <amxmodx>
#include <fakemeta>
#include <fakemeta_util>

#define AUTHOR "tuty"

new const Plugin[] = "Healthkit on dead body"
new const Version[] = "2.0"

#define medkit_minsz Float:{ -23.160000, -13.660000, -0.050000 } // from hl model viewer
#define medkit_maxsz Float:{ 11.470000, 12.780000, 6.720000 } // from hl model viewer

new const MODEL_KIT[] = "models/w_medkit.mdl"
new const SOUND_KIT[] = "items/smallmedkit1.wav" // must be precached because, if you don't precache server will shut down :]

new g_Toggle_KitEnable,g_Toggle_GlowShow,g_GMsgFade, g_Toggle_FadeEnable, g_Toggle_Remove_At_Rstart;

public plugin_init() {
	
	register_plugin(Plugin, Version, AUTHOR);
	register_event("DeathMsg","drop_kit","a");
	register_logevent("logevent_round_start",2,"1=Round_Start");
	register_forward(FM_Touch,"fw_touch");
	// Add your code here...
	g_Toggle_KitEnable = register_cvar("kit_enable", "1");
	g_Toggle_GlowShow = register_cvar("kit_glow", "1");
	g_Toggle_FadeEnable = register_cvar("kit_fade", "1");
	g_Toggle_Remove_At_Rstart = register_cvar("kit_remove", "0");
	g_GMsgFade = get_user_msgid("ScreenFade");
	
	
}
public plugin_precache()
{
	
	engfunc(EngFunc_PrecacheModel, MODEL_KIT);
	engfunc(EngFunc_PrecacheSound, SOUND_KIT);
}
public drop_kit()
{

	if(get_pcvar_num(g_Toggle_KitEnable) == 0)
		return FMRES_IGNORED;
		
	new victim = read_data(2);
	static Float:origin[3];
	pev(victim,pev_origin,origin);
	
	new ent = fm_create_entity("item_healthkit");
	origin[2] -= 36; // the distance of ground and kit..this is perfect fixed.. do not edit :/
	engfunc(EngFunc_SetOrigin,ent,origin);
	
	if(!pev_valid(ent))
		return FMRES_IGNORED;// check for valid ent
	
	engfunc(EngFunc_SetModel,ent,MODEL_KIT);
	set_pev(ent,pev_classname,"item_healthkit");
	dllfunc(DLLFunc_Spawn, ent);
	set_pev(ent,pev_solid,SOLID_BBOX);
	set_pev(ent,pev_movetype,MOVETYPE_NONE);
	engfunc(EngFunc_SetSize,ent,medkit_minsz, medkit_maxsz);
	engfunc(EngFunc_DropToFloor,ent);
	if(get_pcvar_num(g_Toggle_GlowShow) == 1)
	{
		
		fm_set_rendering(ent, kRenderFxGlowShell, 255, 255, 255, kRenderFxNone, 27);
	}
	
	return FMRES_IGNORED;
	
}
public fw_touch(ent,id)
{
	
	if(get_pcvar_num(g_Toggle_KitEnable) == 0)
		return FMRES_IGNORED;
	
	new classname[32];
	pev(ent,pev_classname,classname,31);
	if(!equal(classname, "item_healthkit"))// check for kit 
		return FMRES_IGNORED;
	
	new health = get_user_health(id);
	if(health >= 100)//check if player health is 100 and block access to take the kit :D
	{
		client_print(id, print_center, "У вас максимум здоровья,аптечка вам не нужна!"); 
		return FMRES_IGNORED;
	}
	fm_give_item(id, "item_healthkit");
	
	if(get_pcvar_num(g_Toggle_FadeEnable) == 1)
	{
		
		message_begin(MSG_ONE_UNRELIABLE, g_GMsgFade , {0,0,0}, id);
		write_short(1<<10);
		write_short(1<<10);
		write_short(0x0000);
		write_byte(255);//r
		write_byte(0);  //g
		write_byte(0);  //b
		write_byte(75);
		message_end();
	}
	engfunc(EngFunc_RemoveEntity,ent);
	
	return FMRES_IGNORED;
}
// remove kit on round start if kit_remove is 1
public logevent_round_start()
{
	if(get_pcvar_num(g_Toggle_Remove_At_Rstart) == 0)
		return FMRES_IGNORED;
		
	new hkit = -1;
	while ((hkit = fm_find_ent_by_class(hkit, "item_healthkit")))
		engfunc(EngFunc_RemoveEntity, hkit);
		
	return FMRES_IGNORED;
		
}
